function [fitresult, gof] = createFit(persuit_x_fitting, persuit_phase_fitting)
%CREATEFIT(PERSUIT_X_FITTING,PERSUIT_PHASE_FITTING)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : persuit_x_fitting
%      Y Output: persuit_phase_fitting
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%   FIT, CFIT, SFIT.

%   MATLAB  02-Aug-2020 14:34:08 Զ


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( persuit_x_fitting, persuit_phase_fitting );

% Set up fittype and options.
ft = fittype( 'smoothingspline' );
opts = fitoptions( 'Method', 'SmoothingSpline' );
opts.SmoothingParam = 0.999999999985019;

% Fit model to data.
% [fitresult, gof] = fit( xData, yData, ft);
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, xData, yData );
legend( h, 'persuit_phase_fitting vs. persuit_x_fitting', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
xlabel persuit_x_fitting
ylabel persuit_phase_fitting
grid on


